---
title: Styling
---

There are a number of options to allow styling an axis. There are settings to control [grid lines](#grid-line-configuration) and [ticks](#tick-configuration).

## Grid Line Configuration

The grid line configuration is nested under the scale configuration in the `gridLines` key. It defines options for the grid lines that run perpendicular to the axis.

| Name | Type | Scriptable | Indexable | Default | Description
| ---- | ---- | :-------------------------------: | :-----------------------------: | ------- | -----------
| `display` | `boolean` | | | `true` | If false, do not display grid lines for this axis.
| `borderColor` | [`Color`](../general/colors.md) | | | | If set, used as the color of the border line. If unset, the first `color` option is resolved and used.
| `borderWidth` | `number` | | | | If set, used as the width of the border line. If unset, the first `lineWidth` option is resolved and used.
| `circular` | `boolean` | | | `false` | If true, gridlines are circular (on radar chart only).
| `color` | [`Color`](../general/colors.md)  | Yes | Yes | `'rgba(0, 0, 0, 0.1)'` | The color of the grid lines. If specified as an array, the first color applies to the first grid line, the second to the second grid line and so on.
| `borderDash` | `number[]` | | | `[]` | Length and spacing of dashes on grid lines. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/setLineDash).
| `borderDashOffset` | `number` | Yes | | `0.0` | Offset for line dashes. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset).
| `lineWidth` | `number` | Yes | Yes | `1` | Stroke width of grid lines.
| `drawBorder` | `boolean` | | | `true` | If true, draw border at the edge between the axis and the chart area.
| `drawOnChartArea` | `boolean` | | | `true` | If true, draw lines on the chart area inside the axis lines. This is useful when there are multiple axes and you need to control which grid lines are drawn.
| `drawTicks` | `boolean` | | | `true` | If true, draw lines beside the ticks in the axis area beside the chart.
| `tickMarkLength` | `number` | | | `10` | Length in pixels that the grid lines will draw into the axis area.
| `offsetGridLines` | `boolean` | | | `false` | If true, grid lines will be shifted to be between labels. This is set to `true` for a bar chart by default.
| `z` | `number` | | | `0` | z-index of gridline layer. Values &lt;= 0 are drawn under datasets, &gt; 0 on top.

The scriptable context has the following form:

```javascript
{
    chart,
    scale,
    index,
    tick
}
```

## Tick Configuration

The tick configuration is nested under the scale configuration in the `ticks` key. It defines options for the tick marks that are generated by the axis.

| Name | Type | Scriptable | Default | Description
| ---- | ---- | :-------------------------------: | ------- | -----------
| `alignment` | `string` | | `'center'` | The tick alignment along the axis. Can be `'start'`, `'center'`, or `'end'`.
| `callback` | `function` | | | Returns the string representation of the tick value as it should be displayed on the chart. See [callback](../axes/labelling.md#creating-custom-tick-formats).
| `display` | `boolean` | | `true` | If true, show tick labels.
| `font` | `Font` | Yes | `defaults.font` | See [Fonts](../general/fonts.md)
| `major` | `object` | | `{}` | [Major ticks configuration](#major-tick-configuration).
| `padding` | `number` | | `0` | Sets the offset of the tick labels from the axis
| `z` | `number` | | `0` | z-index of tick layer. Useful when ticks are drawn on chart area. Values &lt;= 0 are drawn under datasets, &gt; 0 on top.

The scriptable context is the same as for the [Grid Line Configuration](#grid-line-configuration).

## Major Tick Configuration

The majorTick configuration is nested under the ticks configuration in the `major` key. It defines options for the major tick marks that are generated by the axis.

| Name | Type | Default | Description
| ---- | ---- | ------- | -----------
| `enabled` | `boolean` | `false` | If true, major ticks are generated. A major tick will affect autoskipping and `major` will be defined on ticks in the scriptable options context.
